<?php
$file_path = __DIR__ . '/board.csv';
$total_sum = 0;
$leader = '';
$highest_monthly = 0;
$target = '';
$rows = [];

if (!file_exists($file_path)) {
    echo json_encode(['error' => 'No CSV file.']);
    exit;
}

$handle = fopen($file_path, 'r');
if ($handle === false) {
    echo json_encode(['error' => 'Problem when open CSV file.']);
    exit;
}

$target = fgetcsv($handle)[5];

while (($data = fgetcsv($handle)) !== false) {
    $agent = htmlspecialchars($data[0]);
    $monthly = htmlspecialchars($data[1]);
    $daily = htmlspecialchars($data[2]);
    $ftd = htmlspecialchars($data[3]);
    $withdraw = htmlspecialchars($data[4]);
    $playerValue = htmlspecialchars($data[6]);
    $success =  htmlspecialchars($data[7]);

    $total_sum += intval($monthly);

    if (intval($monthly) > $highest_monthly) {
        $highest_monthly = intval($monthly);
        $leader = $agent;
    }

    $rows[] = ['agent' => $agent, 'monthly' => $monthly, 'daily' => $daily, 'ftd' => $ftd, 'withdraw' => $withdraw, 'playerValue' => $playerValue, 'success' => $success];
}

fclose($handle);

echo json_encode([
    'rows' => $rows,
    'total_sum' => $total_sum,
    'leader' => $leader,
    'target' => $target,
    'ftd' => $ftd,
    'withdraw' => $withdraw
]);
?>
