<?php
// Fetching and saving the CSV data from Google Sheets
$sheet_id = '1CY4IH6fOWcJ_ZkwpIb0_YiskHTi7LXd7d5L2iH3flOQ';
$url = "https://docs.google.com/spreadsheets/d/{$sheet_id}/gviz/tq?tqx=out:csv";
$csv_data = file_get_contents($url);

if ($csv_data === false) {
    die("Error fetching the CSV data.");
}

$file_path = __DIR__ . '/board.csv'; // Saving the CSV data to a local file
file_put_contents($file_path, $csv_data);

// Process the CSV data
$total_daily = 0;
$total_monthly = 0;
$leader = '';
$highest_monthly = 0;
$target = '';
$rows = [];

if (!file_exists($file_path)) {
    echo json_encode(['error' => 'No CSV file.']);
    exit;
}

$handle = fopen($file_path, 'r');
if ($handle === false) {
    echo json_encode(['error' => 'Problem when opening CSV file.']);
    exit;
}

// Read the target value from the first row
$header = fgetcsv($handle);
$target = htmlspecialchars($header[5]); // Assuming target is in the sixth column

while (($data = fgetcsv($handle)) !== false) {
    if (count($data) < 8) {
        continue; // Skip rows with insufficient data
    }

    $agent = htmlspecialchars($data[0]);
    $monthly = intval($data[1]); // Monthly value
    $daily = intval($data[2]); // Daily value
    $ftd = htmlspecialchars($data[3]); // FTD values
    $withdraw = intval($data[4]); // Withdraw values
    $playerValue = htmlspecialchars($data[6]); // Player Value
    $success = htmlspecialchars($data[7]); // Success %

    // Update leader and highest monthly value without adjustment
    if ($monthly > $highest_monthly) {
        $highest_monthly = $monthly;
        $leader = $agent;
    }

    $rows[] = [
        'agent' => $agent,
        'daily' => $daily,
        'monthly' => $monthly,
        'ftd' => $ftd,
        'withdraw' => $withdraw,
        'playerValue' => $playerValue,
        'success' => $success
    ];

    $total_daily += $daily;
    $total_monthly += $monthly;
}

fclose($handle);

echo json_encode([
    'rows' => $rows,
    'total_daily' => $total_daily,
    'total_monthly' => $total_monthly,
    'leader' => $leader,
    'target' => $target
]);
?>
