<!DOCTYPE html>
<html>

<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-size: 1em;
        }

        @media (max-width: 768px) {
            body {
                font-size: 1em;
            }
        }

        @media (min-width: 769px) {
            body {
                font-size: 1em;
            }
        }

        td.cell-danger {
            background-color: #dc3545 !important;
            color: white;
        }

        td.cell-success {
            background-color: #28a745 !important;
            color: white;
        }

        td.gold {
            background-color: #ffd700; /* Gold */
            color: black;
        }

        td.silver {
            background-color: #c0c0c0; /* Silver */
            color: black;
        }

        td.bronze {
            background-color: #cd7f32; /* Bronze */
            color: white;
        }

        h1 {
            font-size: 3rem !important;
        }

        .card-header {
            font-size: 3rem !important;
            color: white; /* Ensure header text is visible */
        }

        .card-body {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            color: white; /* Ensure body text is visible */
        }

        .leader-card {
            background-image: url('dollar.jpg'); /* Replace with your image path */
            background-size: cover; /* Cover the entire card */
            background-position: center; /* Center the background image */
            background-repeat: no-repeat; /* Prevent repeating the background image */
        }

        /* Outline text style */
        .text-outline {
            font-size: 4rem; /* Adjust font size as needed */
            font-weight: bold; /* Makes the text more prominent */
            color: #FFD700; /* Text color */
            text-shadow:
                3px 3px 0 #000,
                -3px -3px 0 #000,
                3px -3px 0 #000,
                -3px 3px 0 #000; /* Black outline effect */
        }

        .card-body-content {
            padding: 20px;
            height: 25vh; /* Adjust height as needed */
        }

        .agent-column {
            font-size: 1.1rem; /* Increase font size for Agent column */
        }

        .ftd-column {
            font-size: 1.1rem; /* Increase font size for FTD's column */
        }

        .player-value-column {
            font-size: 1.1rem; /* Increase font size for Player Value column */
        }

        .success-column {
            font-size: 1.1rem; /* Increase font size for Success column */
        }

        .target-text {
            font-size: 5rem; /* Adjust font size as needed */
            color: #000000; /* Change this to your desired color */
        }

        .target-label {
            font-size: 3rem;
            color: black; /* Change to black */
        }

        /* Style for the "Leader:" label with outline */
        .leader-label {
            font-size: 3.5rem;
            color: #FFD700; /* Text color for "Leader:" */
            text-shadow:
                2px 2px 0 #000,
                -2px -2px 0 #000,
                2px -2px 0 #000,
                -2px 2px 0 #000; /* Black outline effect */
        }

        .leader-text {
            font-size: 5rem; /* Adjust font size as needed */
            color: #FFD700; /* Text color */
            text-shadow:
                3px 3px 0 #000,
                -3px -3px 0 #000,
                3px -3px 0 #000,
                -3px 3px 0 #000; /* Black outline effect */
            margin-top: -30px; /* Adjust as needed */
            margin-bottom: 20px; /* Adjust as needed */
            margin-left: 10px; /* Adjust as needed */
            margin-right: 10px; /* Adjust as needed */
        }

    </style>
</head>

<body>
    <?php
    ini_set('session.cookie_lifetime', 12 * 60 * 60);
    session_start();

    $password = '4r5t6y';

    if (isset($_POST['password']) && $_POST['password'] == $password) {
        $_SESSION['authenticated'] = true;
        $_SESSION['login_time'] = time();
    }

    if (!isset($_SESSION['authenticated']) || time() - $_SESSION['login_time'] > 12 * 60 * 60) {
        session_unset();
        session_destroy();

        echo '<form method="POST">
            <input type="password" name="password">
            <input type="submit" value="Enter">
        </form>';
        exit;
    }
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-8">
                <table class="table table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Agent</th>
                            <th>Daily</th>
                            <th>Monthly</th>
                            <th>FTD's</th>
                            <th>Withdraw</th>
                            <th>Player Value $</th>
                            <th>Success %</th>
                        </tr>
                    </thead>
                    <tbody id="table_body">
                    </tbody>
                </table>
            </div>
            <div class="col-12 col-md-4 border-start d-flex flex-column justify-content-between text-center">
                <div class="card text-bg-warning mb-3 flex-grow-1">
                    <div class="card-header target-label">TARGET</div>
                    <div class="card-body d-flex align-items-center justify-content-center">
                        <h1 class="target-text" id="target"></h1>
                    </div>
                </div>
                <div class="card text-bg-primary mb-3 flex-grow-1 leader-card">
                    <div class="card-header leader-label">LEADER</div>
                    <div class="card-body card-body-content" id="leader">
                        <div class="leader-text">
                            <!-- Leader content will be injected here by JavaScript -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
let previousDailyValues = {};

(function() {
    const tableBody = document.querySelector('#table_body');
    const leaderElement = document.getElementById('leader');
    const targetElement = document.getElementById('target');
    let updateInterval;

    function fetchAndUpdate() {
        const xhr = new XMLHttpRequest();
        xhr.open('GET', 'combined_script.php', true); // Ensure this is the correct path to the PHP script

        xhr.onload = function() {
            if (this.status == 200) {
                const response = JSON.parse(this.responseText);

                if (response.error) {
                    console.error(response.error);
                    return;
                }

                response.rows.sort((a, b) => parseInt(b.monthly) - parseInt(a.monthly));

                let tableContent = '';
                let total_daily = 0;
                let total_monthly = 0;
                let total_withdraw = 0; // Initialize total_withdraw
                let row_number = 0;

                for (let [index, row] of response.rows.entries()) {
    row_number++;
    const isLeader = (row.agent === response.leader);
    const daily = parseInt(row.daily).toLocaleString();
    const monthly = parseInt(row.monthly).toLocaleString();
    const withdraw = parseInt(row.withdraw).toLocaleString();
    const ftd = row.ftd;
    const playerValue = row.playerValue;
    const success = row.success;

    let daily_class = '';
    let monthly_class = '';
    let agent_class = '';

    if (parseInt(row.daily) <= 0) {
        daily_class = 'cell-danger'; // Red if 0 or less
    } else {
        daily_class = 'cell-success'; // Green if greater than 0
    }

    if (parseInt(row.monthly) <= 0) {
        monthly_class = 'cell-danger'; // Red if 0 or less
    } else {
        monthly_class = 'cell-success'; // Green if greater than 0
    }

    // Apply different background colors to the Agent column
    if (index === 0) {
        agent_class = 'gold';
    } else if (index === 1) {
        agent_class = 'silver';
    } else if (index === 2) {
        agent_class = 'bronze';
    }

    tableContent += isLeader ? '<tr class="table-warning">' : '<tr>';
    tableContent += `<td class="agent-column ${agent_class}">${row_number}. ${row.agent}</td>`;
    tableContent += `<td class="${daily_class}" style="color: white; font-size: 1.1rem; font-weight: bold;">${daily}</td>`;
    tableContent += `<td class="${monthly_class}" style="color: white; font-size: 1.1rem; font-weight: bold;">${monthly}</td>`;
    tableContent += `<td class="ftd-column">${ftd}</td>`;
    tableContent += `<td style="color: ${parseInt(row.withdraw) < 0 ? 'red' : 'black'}; font-weight: bold; font-size: 1.1rem;">${withdraw}</td>`;
    tableContent += `<td class="player-value-column">${playerValue}</td>`;
    tableContent += `<td class="success-column">${success}</td>`;
    tableContent += '</tr>';

    total_daily += parseInt(row.daily);
    total_monthly += parseInt(row.monthly);
    total_withdraw += parseInt(row.withdraw); // Add to total_withdraw

    previousDailyValues[row.agent] = parseInt(row.daily);
}

tableContent += '<tr class="table-primary" style="font-size: 1.5rem;">';
tableContent += '<td>Total:</td>';
tableContent += `<td><b>${total_daily.toLocaleString()}</b></td>`;
tableContent += `<td><b>${total_monthly.toLocaleString()}</b></td>`;
tableContent += `<td></td>`; // Placeholder for FTD's column
tableContent += `<td><b>${total_withdraw.toLocaleString()}</b></td>`; // Total for Withdraw column
tableContent += '</tr>';

document.querySelector('#table_body').innerHTML = tableContent;

// Update leaderElement with both the leader's name and formatted monthly value
const leaderMonthlyValue = parseInt(response.rows.find(row => row.agent === response.leader).monthly).toLocaleString();
leaderElement.innerHTML = `
    <div class="leader-text">
        <div>${response.leader}</div>
        <div>$${leaderMonthlyValue}</div>
    </div>
`;

targetElement.innerHTML = `
    <div class="target-text">
        ${response.target}
    </div>
`;

            }
        };

        xhr.send();
    }

    function startFetching() {
        fetchAndUpdate();
    }

    startFetching();
    updateInterval = setInterval(startFetching, 1000);

    window.addEventListener('beforeunload', function() {
        clearInterval(updateInterval);
    });
})();
</script>

</body>

</html>
