<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Define the CSV file path
$csv_file_path = __DIR__ . '/board.csv';

// Function to fetch and save CSV data from Google Sheets
function fetchAndSaveCSV($url, $file_path) {
    $csv_data = @file_get_contents($url);
    if ($csv_data === false) {
        error_log("Error fetching the CSV data from URL: $url");
        return false;
    }

    $result = @file_put_contents($file_path, $csv_data);
    if ($result === false) {
        error_log("Error saving the CSV data to file: $file_path");
        return false;
    }

    return true;
}

// URL to fetch CSV data from Google Sheets
$google_sheets_url = 'https://docs.google.com/spreadsheets/d/1CY4IH6fOWcJ_ZkwpIb0_YiskHTi7LXd7d5L2iH3flOQ/gviz/tq?tqx=out:csv&sheet=Conversion';

// Function to check if the CSV file should be updated
function shouldUpdateCSV($file_path, $update_interval = 10) {
    // Check if the file exists and get its modification time
    if (!file_exists($file_path)) {
        return true; // File is missing, so it should be updated
    }
    
    // Check if the file modification time is older than the update interval
    $file_mod_time = filemtime($file_path);
    if (time() - $file_mod_time >= $update_interval) {
        return true; // File is outdated
    }

    return false; // File is up-to-date
}

// Update the CSV file if needed
if (shouldUpdateCSV($csv_file_path)) {
    if (!fetchAndSaveCSV($google_sheets_url, $csv_file_path)) {
        http_response_code(500);
        die("Error fetching or saving the CSV data.");
    }
}

// Read and parse the CSV file
$csv_data = file_get_contents($csv_file_path);
if ($csv_data === false) {
    http_response_code(500);
    die("Error reading CSV file.");
}

$rows = array_map('str_getcsv', explode("\n", $csv_data));
$header = array_map('trim', array_shift($rows));

// Validate CSV headers
$required_headers = ['Agent', 'YHMWU', 'Target', 'Sky', 'FTD'];
$header_lower = array_map('strtolower', $header);
$required_headers_lower = array_map('strtolower', $required_headers);

if (array_diff($required_headers_lower, $header_lower)) {
    echo json_encode(['error' => 'CSV file is missing required columns.']);
    exit;
}

// Process the CSV data
$data = [];
foreach ($rows as $row) {
    if (count($row) >= count($header)) {
        // Replace NaN or empty values with empty strings
        $row = array_map(function($value) {
            return $value === 'NaN' ? '' : $value;
        }, array_combine($header, array_slice($row, 0, count($header))));

        $data[] = $row;
    }
}

// Calculate leader and target (Modify logic if needed)
// Placeholder logic
$leader = 'Leader Name'; // Update this with actual leader calculation if needed
$target = 'Target Value'; // Update this with actual target calculation if needed

// Return the JSON response
header('Content-Type: application/json');
echo json_encode([
    'rows' => $data,
    'leader' => $leader,
    'target' => $target
]);
?>