<!DOCTYPE html>
<html>

<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
    body {
        font-size: 1em;
    }

    @media (max-width: 768px) {
        body {
            font-size: 1em;
        }
    }

    @media (min-width: 769px) {
        body {
            font-size: 1.2em;
        }
    }

    td.cell-danger {
        background-color: #de2629; /* Dark red */
    }

    td.cell-success {
        background-color: #52ba6c !important; /* Dark green */
    }

    td.cell-target-danger {
        background-color: #de2629; /* Dark red */
    }

    td.cell-target-success {
        background-color: #52ba6c !important; /* Dark green */
    }
	td.cell-sky-danger {
    background-color: #de2629; /* Red background for Sky Target */
	}

	td.cell-sky-success {
    background: url('gold-foil.jpg') no-repeat center center; /* Gold background image */
    background-size: cover; /* Cover the whole element */
	}
    h1 {
        font-size: 3rem !important;
    }
	h2 {
        font-size: 3.0rem !important;
    }

    .card-header {
        font-size: 2rem !important;
    }

    .leader-container {
        background-color: #FFD700; /* Gold color */
		padding: 110px;
        margin-top: 55px;
        border-radius: 5px;
        text-align: center; /* Center content */
		background: url('gold-foil.jpg') no-repeat center center; /* Background image */
        background-size: cover; /* Cover the whole element */
    }

   

    table tbody tr:last-child {
        font-size: 1.5em; /* Adjust this value to change the font size */
    }

    .total-display {
        position: relative;
        margin-top: 40px;
        font-size: 2em;
        text-align: center; /* Center the text */
        border: 2px solid #000; /* Black border */
        padding: 100px; /* Padding inside the border */
        border-radius: 5px; /* Rounded corners */
        overflow: hidden; /* Hide overflow for pseudo-element */
        font-weight: bold; /* Bold text */
		white-space: nowrap;
		color: gold;
		-webkit-text-stroke: 2px black;
		
    }

    .total-display::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: url('total_background.jpg') no-repeat center center; /* Background image */
        background-size: cover; /* Cover the whole element */
        opacity: 0.99; /* 25% opacity */
        z-index: -1; /* Place behind the text */
    }

    .total-display p {
        position: relative; /* Ensure text is on top of background */
    }
	.bg-white {
    background-color: #ffffff !important; /* White background */
}
</style>

</head>

<body>
    <?php
    session_start();

    $password = '7u8i9o';

    if (isset($_POST['password']) && $_POST['password'] == $password) {
        $_SESSION['authenticated'] = true;
    }

    if (!isset($_SESSION['authenticated'])) {
        echo '<form method="POST">
        <input type="password" name="password">
        <input type="submit" value="Enter">
    </form>';
        exit;
    }
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-8">
                <table class="table table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>Agent</th>
                            <th>YHMWU</th>
                            <th>Target</th>
							<th>Sky</th>
                            <th>FTD</th>
                        </tr>
                    </thead>
                    <tbody id="table_body">
                    </tbody>
                </table>
            </div>
            <div class="col-12 col-md-4">
                <div class="leader-container">
                    <h2 id="leader"></h2>
                </div>
                <!-- Separate container for the image, positioned below the leader rectangle -->
                
                <!-- Display totals below the image -->
                <div class="total-display">
                    <p id="total-target">Target: </p>
                    <p id="total-yhwm">Total YHMWU: </p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function fetchAndUpdate() {
    const xhr = new XMLHttpRequest();
    xhr.open('GET', 'combined_script.php', true);

    xhr.onload = function () {
        if (this.status === 200) {
            try {
                const response = JSON.parse(this.responseText);
                console.log('Response from combined_script.php:', response);

                if (response.error) {
                    console.error('Error from server:', response.error);
                    return;
                }

                const rows = response.rows;
                if (!Array.isArray(rows)) {
                    throw new Error('Invalid data format: rows is not an array');
                }

                // Sort rows by YHMWU in descending order
                rows.sort((a, b) => parseFloat(b.YHMWU) - parseFloat(a.YHMWU));

                // Extract the top 4 unique YHMWU values
                const uniqueYHMWU = [...new Set(rows.map(row => parseFloat(row.YHMWU)))];
                const [yhmwumax1, yhmwumax2, yhmwumax3, yhmwumax4] = uniqueYHMWU.slice(0, 4);

                let tableContent = '';
                let leaderNames = [];
                let highestYHMWU = -Infinity;

                let totalYHMWU = 0;
                let totalTarget = 0;
                let totalSky = 0; // Initialize totalSky
                let totalFTD = 0;

                let position = 1; // Initialize counter for position

                for (let row of rows) {
                    const agent = row['Agent'];
                    const yhwmValue = parseFloat(row['YHMWU']);
                    const targetValue = parseFloat(row['Target']);
                    const skyTargetValue = parseFloat(row['Sky']);
                    const ftdValue = parseFloat(row['FTD']);

                    // Determine the emoji based on YHMWU value
                    let agentWithEmoji = agent;
                    let agentForLeader = agent; // Variable without emoji for leader display
                    if (!isNaN(yhwmValue)) {
                        if (yhwmValue === yhmwumax1) {
                            agentWithEmoji += ' 🥇'; // Gold medal for the highest value
                        } else if (yhwmValue === yhmwumax2) {
                            agentWithEmoji += ' 🥈'; // Silver medal for the second highest value
                        } else if (yhwmValue === yhmwumax3) {
                            agentWithEmoji += ' 🥉'; // Bronze medal for the third highest value
                        }
                    } else {
                        yhwmValue = ''; // Set to empty string if NaN
                    }

                    // Determine the class for YHMWU
                    let yhwmClass = !isNaN(yhwmValue) ? 'cell-success' : 'bg-white';

                    // Determine the class for Target based on YHMWU and Target values
                    let targetClass = !isNaN(yhwmValue) && yhwmValue < targetValue ? 'cell-target-danger' : 'cell-target-success';

                    // Determine the class for Sky based on YHMWU and Sky Target values
                    let skyClass = isNaN(skyTargetValue) ? 'bg-white' : (yhwmValue < skyTargetValue ? 'cell-sky-danger' : 'cell-sky-success');

                    // Determine the class for FTD
                    let ftdClass = !isNaN(ftdValue) ? (ftdValue > 0 ? 'cell-success' : 'bg-white') : 'bg-white';

                    // Add position number before the agent's name
                    tableContent += `<tr>`;
                    tableContent += `<td>${position}. ${agentWithEmoji}</td>`;
                    tableContent += `<td class="${yhwmClass}">${isNaN(yhwmValue) ? '' : yhwmValue}</td>`;
                    tableContent += `<td class="${targetClass}">${isNaN(targetValue) ? '' : targetValue}</td>`;
                    tableContent += `<td class="${skyClass}">${isNaN(skyTargetValue) ? '' : skyTargetValue}</td>`; // Add new column
                    tableContent += `<td class="${ftdClass}">${isNaN(ftdValue) ? '' : ftdValue}</td>`;
                    tableContent += `</tr>`;

                    // Accumulate totals
                    totalYHMWU += !isNaN(yhwmValue) ? yhwmValue : 0;
                    totalTarget += !isNaN(targetValue) ? targetValue : 0;
                    totalSky += !isNaN(skyTargetValue) ? skyTargetValue : 0;
                    totalFTD += !isNaN(ftdValue) ? ftdValue : 0;

                    if (yhwmValue > highestYHMWU) {
                        highestYHMWU = yhwmValue;
                        leaderNames = [agentForLeader];
                    } else if (yhwmValue === highestYHMWU) {
                        leaderNames.push(agentForLeader);
                    }

                    position++; // Increment position for the next agent
                }

                // Add totals row
                tableContent += `<tr class="table-primary">`;
                tableContent += `<td><strong>Total:</strong></td>`;
                tableContent += `<td><strong>${totalYHMWU}</strong></td>`;
                tableContent += `<td><strong>${totalTarget}</strong></td>`;
                tableContent += `<td></td>`; // Remove totalSky value
                tableContent += `<td><strong>${totalFTD}</strong></td>`;
                tableContent += `</tr>`;

                document.querySelector('#table_body').innerHTML = tableContent;

                // Display leaders without emojis, each on a new line
                document.getElementById('leader').innerHTML = "Leader(s):<br>" + leaderNames.join('<br>');

                // Update the totals below the image
                document.getElementById('total-target').textContent = "Target: " + totalTarget;
                document.getElementById('total-yhwm').textContent = "Total YHMWU: " + totalYHMWU;

            } catch (e) {
                console.error('Error parsing JSON:', e);
            }
        } else {
            console.error('Error fetching data:', this.status, this.statusText);
        }
    };

    xhr.onerror = function () {
        console.error('Request error');
    };

    xhr.send();
}

        // Fetch data and update table
        fetchAndUpdate();
        setInterval(fetchAndUpdate, 10000); // Refresh every 10 seconds

    </script>

</body>

</html>
